<?php

namespace app\controllers;

use Yii;
use yii\web\Controller;
use app\models\Event;
use app\models\Game;
use app\models\User;

class SiteController extends Controller
{
    public function actionIndex()
    {
        // Слайдер: популярные игры (выберем первые 6)
        $popularGames = Game::find()->limit(6)->all();

        // График игр на ближайший месяц
        $upcomingEvents = Event::find()
            ->where(['>=', 'date', date('Y-m-d')])
            ->andWhere(['<=', 'date', date('Y-m-d', strtotime('+1 month'))])
            ->orderBy('date, start_time')
            ->with('game')
            ->all();

        return $this->render('index', [
            'popularGames' => $popularGames,
            'upcomingEvents' => $upcomingEvents,
        ]);
    }

    public function actionAbout()
    {
        return $this->render('about');
    }

    public function actionGames()
    {
        $games = Game::find()
            ->with('category')
            ->orderBy('category_id, name')
            ->all();
        return $this->render('games', ['games' => $games]);
    }

    public function actionContact()
    {
        return $this->render('contact');
    }
}