<?php

namespace app\models;

use yii\db\ActiveRecord;

/**
 * @property int $id
 * @property int $user_id
 * @property int $event_id
 * @property string $payment_method
 * @property string $player_level
 * @property int $consent
 * @property string $status
 * @property string $created_at
 */
class Application extends ActiveRecord
{
    const STATUS_NEW = 'new';
    const STATUS_APPROVED = 'approved';
    const STATUS_COMPLETED = 'completed';

    const LEVEL_BEGINNER = 'новичок';
    const LEVEL_AMATEUR = 'любитель';
    const LEVEL_PRO = 'профессионал';

    const PAY_CASH = 'наличными';
    const PAY_CARD = 'картой';
    const PAY_TRANSFER = 'переводом';

    public static function tableName()
    {
        return 'application';
    }

    public function rules()
    {
        return [
            [['user_id', 'event_id', 'payment_method', 'player_level'], 'required'],
            ['consent', 'required', 'requiredValue' => 1, 'message' => 'Необходимо согласие на обработку персональных данных.'],
            ['consent', 'boolean'],
            ['status', 'in', 'range' => [self::STATUS_NEW, self::STATUS_APPROVED, self::STATUS_COMPLETED]],
            [['payment_method', 'player_level'], 'string'],
        ];
    }

    public function attributeLabels()
    {
        return [
            'payment_method' => 'Способ оплаты',
            'player_level' => 'Уровень игрока',
            'consent' => 'Согласие на обработку персональных данных',
        ];
    }

    // Отношения
    public function getUser()
    {
        return $this->hasOne(User::class, ['id' => 'user_id']);
    }

    public function getEvent()
    {
        return $this->hasOne(Event::class, ['id' => 'event_id']);
    }
}