<?php

use yii\helpers\Html;
use yii\helpers\Url;
use app\models\Application;

/** @var yii\web\View $this */
/** @var Application[] $applications */

$this->title = 'Панель администратора';
?>
<div class="container">
    <h1 class="mb-4">Панель администратора</h1>

    <?php if (Yii::$app->session->hasFlash('success')): ?>
        <div class="alert alert-success">
            <?= Yii::$app->session->getFlash('success') ?>
        </div>
    <?php endif; ?>

    <?php if (empty($applications)): ?>
        <div class="alert alert-info">
            Нет заявок.
        </div>
    <?php else: ?>
        <table class="table">
            <thead>
            <tr>
                <th>Игрок</th>
                <th>Игра</th>
                <th>Дата</th>
                <th>Время</th>
                <th>Уровень</th>
                <th>Статус</th>
                <th>Действия</th>
            </tr>
            </thead>
            <tbody>
            <?php foreach ($applications as $app): ?>
                <tr>
                    <td><?= htmlspecialchars($app->user->fullname) ?></td>
                    <td><?= htmlspecialchars($app->event->game->name) ?></td>
                    <td><?= Yii::$app->formatter->asDate($app->event->date, 'php:d.m.Y') ?></td>
                    <td><?= $app->event->start_time ?></td>
                    <td><?= $app->player_level ?></td>
                    <td>
                        <?php if ($app->status === 'new'): ?>
                            <span class="badge bg-warning">Новая</span>
                        <?php elseif ($app->status === 'approved'): ?>
                            <span class="badge bg-success">Одобрена</span>
                        <?php else: ?>
                            <span class="badge bg-info">Завершена</span>
                        <?php endif; ?>
                    </td>
                    <td>
                        <?php if ($app->status === 'new'): ?>
                            <form method="post" action="<?= Url::to(['/admin/update-status']) ?>" style="display:inline-block;">
                                <?= Html::hiddenInput(Yii::$app->request->csrfParam, Yii::$app->request->csrfToken) ?>
                                <?= Html::hiddenInput('id', $app->id) ?>
                                <?= Html::hiddenInput('status', 'approved') ?>
                                <button type="submit" class="btn btn-sm btn-success">Одобрить</button>
                            </form>
                            <form method="post" action="<?= Url::to(['/admin/update-status']) ?>" style="display:inline-block;">
                                <?= Html::hiddenInput(Yii::$app->request->csrfParam, Yii::$app->request->csrfToken) ?>
                                <?= Html::hiddenInput('id', $app->id) ?>
                                <?= Html::hiddenInput('status', 'completed') ?>
                                <button type="submit" class="btn btn-sm btn-primary">Завершить</button>
                            </form>
                        <?php else: ?>
                            <span class="text-muted">—</span>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    <?php endif; ?>
</div>