<?php

use yii\helpers\Html;
use yii\helpers\Url;
use app\models\Application;

/** @var yii\web\View $this */
/** @var app\models\Event[] $events */

$this->title = 'Запись на игру';
?>

<div class="auth-page">
    <div class="container">
        <h1>Запись на игру</h1>

        <?php if (empty($events)): ?>
            <p>Нет запланированных игр на ближайшее время.</p>
        <?php else: ?>
            <form method="post">
                <?= Html::hiddenInput(Yii::$app->request->csrfParam, Yii::$app->request->csrfToken) ?>

                <div class="form-group">
                    <label>Выберите игру и дату *</label>
                    <select name="event_id" required>
                        <option value="">— Выберите событие —</option>
                        <?php foreach ($events as $event): ?>
                            <option value="<?= $event->id ?>">
                                <?= htmlspecialchars($event->game->name ?? 'Игра не найдена') ?>
                                — <?= Yii::$app->formatter->asDate($event->date, 'php:d M') ?>
                                в <?= $event->start_time ?>
                                (<?= number_format($event->price, 0, '', ' ') ?> ₽)
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="form-group">
                    <label>Способ оплаты *</label>
                    <select name="payment_method" required>
                        <option value="">— Выберите —</option>
                        <option value="<?= Application::PAY_CASH ?>"><?= Application::PAY_CASH ?></option>
                        <option value="<?= Application::PAY_CARD ?>"><?= Application::PAY_CARD ?></option>
                        <option value="<?= Application::PAY_TRANSFER ?>"><?= Application::PAY_TRANSFER ?></option>
                    </select>
                </div>

                <div class="form-group">
                    <label>Ваш уровень *</label>
                    <select name="player_level" required>
                        <option value="">— Выберите —</option>
                        <option value="<?= Application::LEVEL_BEGINNER ?>"><?= Application::LEVEL_BEGINNER ?></option>
                        <option value="<?= Application::LEVEL_AMATEUR ?>"><?= Application::LEVEL_AMATEUR ?></option>
                        <option value="<?= Application::LEVEL_PRO ?>"><?= Application::LEVEL_PRO ?></option>
                    </select>
                </div>

                <div class="form-group checkbox">
                    <label>
                        <input type="checkbox" name="consent" value="1" required>
                        Я согласен на обработку моих персональных данных *
                    </label>
                </div>

                <button type="submit" class="btn-submit">Забронировать место</button>
            </form>
        <?php endif; ?>
    </div>
</div>