<?php
use yii\helpers\Url;

/** @var yii\web\View $this */
/** @var app\models\Application[] $applications */

$this->title = 'Личный кабинет';
?>
<div class="container">
    <h1 class="mb-4">Личный кабинет</h1>

    <div class="card mb-4">
        <div class="card-body">
            <h5 class="card-title">Добро пожаловать, <?= Yii::$app->user->identity->fullname ?>!</h5>
            <p>Телефон: <?= Yii::$app->user->identity->phone ?></p>
            <p>Email: <?= Yii::$app->user->identity->email ?></p>
            <a href="<?= Url::to(['/auth/logout']) ?>" data-method="post" class="btn btn-outline-secondary">
                Выйти
            </a>
        </div>
    </div>

    <h2 class="mb-3">Ваши заявки</h2>

    <?php if (empty($applications)): ?>
        <div class="alert alert-info">
            У вас пока нет заявок
        </div>
    <?php else: ?>
        <?php foreach ($applications as $app): ?>
            <div class="card mb-3">
                <div class="card-body">
                    <h5 class="card-title"><?= htmlspecialchars($app->event->game->name) ?></h5>
                    <p class="mb-1">Дата: <?= Yii::$app->formatter->asDate($app->event->date, 'php:d.m.Y') ?>, <?= $app->event->start_time ?></p>
                    <p class="mb-1">Адрес: <?= htmlspecialchars($app->event->address) ?></p>
                    <p class="mb-1">Уровень: <?= $app->player_level ?></p>
                    <p class="mb-0">
                        Статус:
                        <span class="badge bg-<?=
                        $app->status === 'new' ? 'warning' :
                            ($app->status === 'approved' ? 'success' : 'info')
                        ?>">
                            <?=
                            $app->status === 'new' ? 'Новая' :
                                ($app->status === 'approved' ? 'Одобрена' : 'Завершена')
                            ?>
                        </span>
                    </p>
                </div>
            </div>
        <?php endforeach; ?>
    <?php endif; ?>

    <div class="mt-4">
        <a href="<?= Url::to(['/application/create']) ?>" class="btn btn-primary">
            Записаться на игру
        </a>
    </div>
</div>