<?php

use yii\helpers\Html;
use yii\helpers\Url;

/** @var yii\web\View $this */
/** @var app\models\User $model */

$this->title = 'Регистрация';
?>
<div class="container">
    <div class="auth-card">
        <h1>Регистрация</h1>

        <?php if (Yii::$app->session->hasFlash('error')): ?>
            <div class="alert alert-danger">
                <?= Yii::$app->session->getFlash('error') ?>
            </div>
        <?php endif; ?>

        <?php if (Yii::$app->session->hasFlash('success')): ?>
            <div class="alert alert-success">
                <?= Yii::$app->session->getFlash('success') ?>
            </div>
        <?php endif; ?>

        <form method="post">
            <?= Html::hiddenInput(Yii::$app->request->csrfParam, Yii::$app->request->csrfToken) ?>

            <div class="mb-3">
                <label for="fullname" class="form-label">ФИО *</label>
                <input type="text"
                       id="fullname"
                       name="User[fullname]"
                       class="form-control"
                       value="<?= Html::encode($model->fullname) ?>"
                       required>
                <?php if ($model->hasErrors('fullname')): ?>
                    <div class="text-danger small"><?= $model->getFirstError('fullname') ?></div>
                <?php endif; ?>
            </div>

            <div class="mb-3">
                <label for="phone" class="form-label">Телефон *</label>
                <input type="tel"
                       id="phone"
                       name="User[phone]"
                       class="form-control"
                       placeholder="8 999 999-99-99"
                       value="<?= Html::encode($model->phone) ?>"
                       required>
                <?php if ($model->hasErrors('phone')): ?>
                    <div class="text-danger small"><?= $model->getFirstError('phone') ?></div>
                <?php endif; ?>
            </div>

            <div class="mb-3">
                <label for="email" class="form-label">Email *</label>
                <input type="email"
                       id="email"
                       name="User[email]"
                       class="form-control"
                       value="<?= Html::encode($model->email) ?>"
                       required>
                <?php if ($model->hasErrors('email')): ?>
                    <div class="text-danger small"><?= $model->getFirstError('email') ?></div>
                <?php endif; ?>
            </div>

            <div class="mb-3">
                <label for="password" class="form-label">Пароль *</label>
                <input type="password"
                       id="password"
                       name="User[password]"
                       class="form-control"
                       minlength="8"
                       required>
                <?php if ($model->hasErrors('password')): ?>
                    <div class="text-danger small"><?= $model->getFirstError('password') ?></div>
                <?php endif; ?>
            </div>

            <div class="mb-3">
                <label for="confirmPassword" class="form-label">Повторите пароль *</label>
                <input type="password"
                       id="confirmPassword"
                       name="User[confirmPassword]"
                       class="form-control"
                       minlength="8"
                       required>
                <?php if ($model->hasErrors('confirmPassword')): ?>
                    <div class="text-danger small"><?= $model->getFirstError('confirmPassword') ?></div>
                <?php endif; ?>
            </div>

            <div class="mb-3 form-check">
                <input type="checkbox" class="form-check-input" id="rules" name="rules" required>
                <label class="form-check-label" for="rules">
                    Согласен с правилами регистрации *
                </label>
            </div>

            <button type="submit" class="btn btn-primary w-100">Зарегистрироваться</button>

            <div class="text-center mt-3">
                <a href="<?= Url::to(['/auth/login']) ?>">Уже есть аккаунт? Войти</a>
            </div>
        </form>
    </div>
</div>