<?php
use yii\helpers\Url;

/** @var yii\web\View $this */
/** @var app\models\Event[] $events */

$this->title = 'Управление играми';
?>

<div class="auth-page">
    <div class="container">
        <h1>Планирование игр</h1>

        <div style="text-align: right; margin-bottom: 20px;">
            <a href="<?= Url::to(['create']) ?>" class="btn-submit" style="width: auto; padding: 10px 20px; font-size: 15px;">
                + Добавить игру
            </a>
        </div>

        <?php if (empty($events)): ?>
            <p>Нет запланированных игр.</p>
        <?php else: ?>
            <div class="events-list">
                <?php foreach ($events as $event): ?>
                    <div class="event-item" style="align-items: flex-start;">
                        <div class="event-date" style="min-width: 100px;">
                            <?= Yii::$app->formatter->asDate($event->date, 'php:d M') ?><br>
                            <?= $event->start_time ?>
                        </div>
                        <div class="event-info">
                            <div class="event-game"><?= htmlspecialchars($event->game->name) ?></div>
                            <div class="event-address"><?= htmlspecialchars($event->address) ?></div>
                            <div class="event-price"><?= number_format($event->price, 0, '', ' ') ?> ₽</div>
                        </div>
                        <div style="margin-left: auto; display: flex; gap: 8px;">
                            <a href="<?= Url::to(['update', 'id' => $event->id]) ?>" class="btn-small">Редактировать</a>
                            <a href="<?= Url::to(['delete', 'id' => $event->id]) ?>"
                               class="btn-small"
                               style="background: #d32f2f;"
                               onclick="return confirm('Удалить событие?')">
                                Удалить
                            </a>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</div>